/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.service;

import inc.yukawa.chain.security.domain.AccessToken;
import inc.yukawa.chain.security.domain.Account;
import inc.yukawa.chain.security.domain.Credentials;
import inc.yukawa.chain.security.domain.RoleContext;
import inc.yukawa.chain.security.jwt.token.JwsAccessToken;
import inc.yukawa.chain.security.jwt.token.json.JsonWebAuthenticationToken;
import inc.yukawa.chain.security.service.TokenAuthService;
import inc.yukawa.chain.security.service.TokenFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import reactor.core.publisher.Mono;

public class OrgTokenAuthService
extends TokenAuthService {
    private static final Logger log = LoggerFactory.getLogger(OrgTokenAuthService.class);
    @Value(value="${chain.security.fixedOrgId:#{null}}")
    private String fixedOrgId;
    @Value(value="${chain.security.checkOrg}")
    private boolean checkOrg;

    @Autowired
    public OrgTokenAuthService(ReactiveUserDetailsService userDetailsService, TokenFactory<Authentication, JwsAccessToken> tokenFactory, PasswordEncoder passwordEncoder) {
        super(userDetailsService, tokenFactory, passwordEncoder);
    }

    @Override
    protected boolean hasAccess(Credentials credentials, Account account, Boolean isPreAuthenticated) {
        if (!super.hasAccess(credentials, account, isPreAuthenticated)) {
            return false;
        }
        if (this.fixedOrgId != null) {
            credentials.setOrgId(this.fixedOrgId);
            return true;
        }
        if (!this.checkOrg) {
            return true;
        }
        Map details = account.getDetails();
        List allowedOrgs = (List)details.get("organisationIds");
        if (allowedOrgs == null || allowedOrgs.isEmpty()) {
            log.debug("hasAccess: {} denied - No allowed orgs", (Object)credentials.getUsername());
            return false;
        }
        if (credentials.getOrgId() == null) {
            credentials.setOrgId((String)details.get("defaultOrgId"));
        }
        if (credentials.getOrgId() != null) {
            if (!allowedOrgs.contains(credentials.getOrgId())) {
                log.debug("hasAccess: {} denied - access to org {} not allowed. {}", new Object[]{credentials.getUsername(), credentials.getOrgId(), allowedOrgs});
                throw new BadCredentialsException("INVALID ORG : " + credentials.getOrgId() + " : " + allowedOrgs);
            }
            return true;
        }
        if (allowedOrgs.size() == 1) {
            credentials.setOrgId((String)allowedOrgs.get(0));
            return true;
        }
        log.debug("hasAccess: {} denied - no orgId found {}", (Object)credentials.getUsername(), (Object)credentials);
        return false;
    }

    @Override
    protected Map<String, Object> buildDetails(Credentials credentials, Account account) {
        HashMap<String, Object> details = new HashMap<String, Object>(account.getDetails());
        details.put("orgId", credentials.getOrgId());
        return details;
    }

    @Override
    protected Set<String> findRoles(Credentials credentials, Account account) {
        Set contexts = account.getRoleContexts();
        if (contexts != null) {
            for (RoleContext context : contexts) {
                if (!credentials.getOrgId().equals(context.getOrgId())) continue;
                Set roles = context.getRoles();
                if (!roles.isEmpty()) {
                    roles.add("ROLE_AUTH");
                }
                return roles;
            }
        }
        log.debug("findRoles: {} - no roleContext for org {} ", (Object)credentials.getUsername(), (Object)credentials.getOrgId());
        return Collections.emptySet();
    }

    @Override
    public Mono<Map<String, Object>> switchOrg(String orgId) {
        return ReactiveSecurityContextHolder.getContext().map(securityContext -> securityContext.getAuthentication().getName()).flatMap(this::loadAccount).handle((account, sink) -> {
            String username = account.getUsername();
            log.debug("switchOrg: {} {} {}", new Object[]{username, orgId, account});
            if (this.hasAccess((Account)account, orgId)) {
                Credentials credentials = new Credentials(username, null, orgId);
                Map<String, Object> details = this.buildDetails(credentials, (Account)account);
                log.debug("switchOrg: {} {} details {}", new Object[]{username, orgId, details});
                List authorities = this.findRoles(credentials, (Account)account).stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
                JsonWebAuthenticationToken authentication = new JsonWebAuthenticationToken(account.getUsername(), null, details, authorities);
                AccessToken accessToken = (AccessToken)this.tokenFactory.createAccessToken((Object)authentication);
                AccessToken refreshToken = (AccessToken)this.tokenFactory.createRefreshToken((Object)authentication);
                this.fireEvent("auth:authenticated", username, accessToken);
                sink.next(this.buildTokenMap(accessToken, refreshToken, (Account)account));
            } else {
                log.debug("switchOrg: {} {} failed - invalid status or org", (Object)username, (Object)orgId);
                this.fireEvent("auth:denied", username, null);
                sink.error((Throwable)new BadCredentialsException(username));
            }
        });
    }

    protected boolean hasAccess(Account user, String orgId) {
        if (!this.hasAccess(user, false)) {
            return false;
        }
        List allowedOrgs = (List)user.getDetails().get("organisationIds");
        if (allowedOrgs == null || allowedOrgs.isEmpty()) {
            log.debug("hasAccess: {} denied - No allowed orgs", (Object)user.getUsername());
            return false;
        }
        if (allowedOrgs.contains(orgId)) {
            return true;
        }
        log.debug("hasAccess: {} denied - org {} not allowed", (Object)user.getUsername(), (Object)orgId);
        return false;
    }
}

