/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.service;

import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.base.core.domain.range.InstantRange;
import inc.yukawa.chain.base.core.filter.Pager;
import inc.yukawa.chain.base.mono.repos.CrudRepository;
import inc.yukawa.chain.base.service.RepoAspectBase;
import inc.yukawa.chain.security.domain.AccessToken;
import inc.yukawa.chain.security.domain.Revocation;
import inc.yukawa.chain.security.domain.RevocationFilter;
import inc.yukawa.chain.security.domain.RevocationType;
import inc.yukawa.chain.security.jwt.token.JwsTokenRevoker;
import inc.yukawa.chain.security.service.RevocationAspect;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class RevocationService
extends RepoAspectBase<Long, Revocation, RevocationFilter>
implements JwsTokenRevoker,
RevocationAspect {
    private static final Logger LOG = LoggerFactory.getLogger(RevocationService.class);

    public RevocationService(CrudRepository<Long, Revocation, RevocationFilter> repo) {
        super(repo);
    }

    public Mono<Boolean> revoke(AccessToken token) {
        if (token.getExpiration().toInstant().isBefore(Instant.now())) {
            return Mono.just((Object)false);
        }
        return this.create((Keyed)new Revocation(token.getSubject(), token.getId(), token.getExpiration().toInstant())).thenReturn((Object)true);
    }

    public Mono<Void> revokeAllBefore(Instant cutOff) {
        Assert.notNull((Object)cutOff, (String)"cutOff");
        Assert.isTrue((!cutOff.isAfter(Instant.now()) ? 1 : 0) != 0, (String)"cutOff shall be in the past");
        RevocationFilter f = new RevocationFilter(RevocationType.GLOBAL_CUT_OFF);
        return this.read(f).flatMap(r -> {
            r.setCutOff(cutOff);
            return this.update((Keyed)r);
        }).switchIfEmpty(this.create((Keyed)new Revocation(cutOff))).then();
    }

    public Mono<Void> revokeAllBefore(String username, Instant cutOff) {
        Assert.notNull((Object)username, (String)"username");
        Assert.notNull((Object)cutOff, (String)"cutOff");
        Assert.isTrue((!cutOff.isAfter(Instant.now()) ? 1 : 0) != 0, (String)"cutOff shall be in the past");
        RevocationFilter f = new RevocationFilter(RevocationType.USER_CUT_OFF);
        f.setUsername(username);
        return this.read(f).flatMap(r -> {
            r.setCutOff(cutOff);
            return this.update((Keyed)r);
        }).switchIfEmpty(this.create((Keyed)new Revocation(username, cutOff))).then();
    }

    public Mono<Void> cleanup() {
        RevocationFilter f = new RevocationFilter(RevocationType.USER_SINGLE);
        f.setRefreshTokenValidityRange(new InstantRange(null, Instant.now()));
        return this.deleteAll(f).collectList().then();
    }

    public Mono<Boolean> isRevoked(AccessToken token) {
        if (token.getExpiration().toInstant().isBefore(Instant.now())) {
            return Mono.just((Object)true);
        }
        InstantRange afterTokenCreation = new InstantRange(token.getIssuedAt().toInstant(), null);
        RevocationFilter revokedByGlobalCutOff = new RevocationFilter(RevocationType.GLOBAL_CUT_OFF, afterTokenCreation);
        RevocationFilter revokedByUserCutOff = new RevocationFilter(RevocationType.USER_CUT_OFF, token.getSubject(), afterTokenCreation);
        RevocationFilter revokedExplicitly = new RevocationFilter(token.getId());
        List revokeFilters = Stream.of(revokedByGlobalCutOff, revokedByUserCutOff, revokedExplicitly).collect(Collectors.toList());
        RevocationFilter revokedByAnyRule = new RevocationFilter(revokeFilters);
        revokedByAnyRule.setPager(new Pager(Integer.valueOf(3)));
        return this.find(revokedByAnyRule).take(3L).collectList().filter(r -> !r.isEmpty()).doOnNext(r -> LOG.debug("Token {} for {} is revoked by Revocations: {}", new Object[]{token.getId(), token.getSubject(), r})).hasElement();
    }
}

