/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.service;

import inc.yukawa.chain.base.core.domain.result.EditResult;
import inc.yukawa.chain.base.core.event.ChainEvent;
import inc.yukawa.chain.base.core.event.EventProducer;
import inc.yukawa.chain.base.mono.dao.MonoLoadDao;
import inc.yukawa.chain.security.domain.AccessToken;
import inc.yukawa.chain.security.domain.Account;
import inc.yukawa.chain.security.domain.Credentials;
import inc.yukawa.chain.security.domain.TokenRequest;
import inc.yukawa.chain.security.event.AccessEvent;
import inc.yukawa.chain.security.externalauth.ExternalAuthService;
import inc.yukawa.chain.security.externalauth.ExternalAuthUtils;
import inc.yukawa.chain.security.jwt.token.JwsAccessToken;
import inc.yukawa.chain.security.jwt.token.json.JsonWebAuthenticationToken;
import inc.yukawa.chain.security.service.AccountAspect;
import inc.yukawa.chain.security.service.AuthAspect;
import inc.yukawa.chain.security.service.TokenFactory;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class TokenAuthService
implements AuthAspect<Mono<Map<String, Object>>> {
    private static final Logger log = LoggerFactory.getLogger(TokenAuthService.class);
    protected final ReactiveUserDetailsService userDetailsService;
    protected final TokenFactory<Authentication, JwsAccessToken> tokenFactory;
    protected final PasswordEncoder passwordEncoder;
    @Autowired(required=false)
    protected EventProducer<String, AccessToken> eventProducer;
    @Autowired
    protected MonoLoadDao<String, Account> loadDao;
    @Autowired
    protected AccountAspect accountService;
    @Autowired
    protected ReactiveAuthenticationManager authManager;
    @Autowired(required=false)
    protected ExternalAuthService externalAuthService;
    @Value(value="${chain.security.passExpiry.enabled:false}")
    private boolean passExpiryEnabled;
    @Value(value="${chain.security.passExpiry.role:ROLE_PASS_EXP}")
    private String passExpiryRole;
    @Value(value="${chain.security.passExpiry.exceptRole:ROLE_NO_PASS_EXP}")
    private String passExpiryExceptRole;
    @Value(value="${chain.security.passExpiry.seconds:0}")
    private long passExpirySeconds;
    @Value(value="${chain.security.passExpiry.invalidateAfterLogin:false}")
    private boolean passExpiryInvalidateAfterLogin;

    @Autowired
    public TokenAuthService(ReactiveUserDetailsService userDetailsService, TokenFactory<Authentication, JwsAccessToken> tokenFactory, PasswordEncoder passwordEncoder) {
        this.userDetailsService = userDetailsService;
        this.tokenFactory = tokenFactory;
        this.passwordEncoder = passwordEncoder;
    }

    public Mono<Map<String, Object>> login(Credentials credentials) {
        return this.getUsernameAndPreAuth(credentials).flatMap(t2 -> this.loadAccount((String)t2.getT1()).map(account -> {
            String username = (String)t2.getT1();
            log.debug("login: {} {}", (Object)username, account);
            if (this.hasAccess(credentials, (Account)account, (Boolean)t2.getT2())) {
                boolean isSubjectOfExpiry;
                Map<String, Object> details = this.buildDetails(credentials, (Account)account);
                log.debug("login: {} details {}", (Object)credentials.getUsername(), details);
                List authorities = this.findRoles(credentials, (Account)account).stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
                JsonWebAuthenticationToken authentication = new JsonWebAuthenticationToken(account.getUsername(), null, details, authorities);
                AccessToken accessToken = (AccessToken)this.tokenFactory.createAccessToken((Object)authentication);
                AccessToken refreshToken = (AccessToken)this.tokenFactory.createRefreshToken((Object)authentication);
                this.fireEvent("auth:authenticated", username, accessToken);
                boolean bl = isSubjectOfExpiry = this.passExpirySeconds((Account)account) != null;
                if (isSubjectOfExpiry && this.passExpiryInvalidateAfterLogin) {
                    this.invalidatePassword((Account)account);
                }
                log.info("login: OK {}", (Object)credentials.getUsername());
                return this.buildTokenMap(accessToken, refreshToken, (Account)account);
            }
            log.debug("login: {} failed - invalid password or status", (Object)username);
            this.fireEvent("auth:denied", username, null);
            throw new BadCredentialsException(username);
        }).doOnSuccess(e -> {
            if (e == null) {
                log.debug("no such user with login: {}", (Object)credentials.getUsername());
                this.fireEvent("auth:noUser", credentials.getUsername(), null);
            }
        }));
    }

    private void invalidatePassword(Account account) {
        log.info("Invalidation password after success login for: {}", (Object)account.getUsername());
        account.setCredentialsNonExpired(false);
        this.accountService.editAccount(account).subscribeOn(Schedulers.boundedElastic()).subscribe();
    }

    protected Mono<Tuple2<String, Boolean>> getUsernameAndPreAuth(Credentials credentials) {
        if (ExternalAuthUtils.isExternalAuth((Credentials)credentials)) {
            if (this.externalAuthService == null) {
                log.warn("ExternalAuthService is not enabled");
                return Mono.error((Throwable)new BadCredentialsException("invalid credentials"));
            }
            log.debug("External login attempt: {}", (Object)credentials);
            return this.externalAuthService.obtainIdToken(credentials).flatMap(token -> this.externalAuthService.readUsername(token, credentials.getProvider())).map(un -> {
                credentials.setUsername(un);
                return Tuples.of((Object)un, (Object)true);
            });
        }
        return Mono.just((Object)Tuples.of((Object)credentials.getUsername(), (Object)false));
    }

    protected Mono<Account> loadAccount(String username) {
        return this.loadDao.load((Object)username).switchIfEmpty(Mono.error((Throwable)new UsernameNotFoundException(username)));
    }

    protected Set<String> findRoles(Credentials credentials, Account user) {
        HashSet<String> roles = new HashSet<String>(user.getRoles());
        if (!roles.isEmpty()) {
            roles.add("ROLE_AUTH");
        }
        return roles;
    }

    protected Map<String, Object> buildDetails(Credentials credentials, Account user) {
        return user.getDetails();
    }

    protected void fireEvent(String event, String username, AccessToken o) {
        if (this.eventProducer != null) {
            this.eventProducer.fireAndForget((ChainEvent)new AccessEvent(event, o), (Object)username, null);
        }
    }

    protected boolean hasAccess(Credentials credentials, Account user, Boolean isPreAuthenticated) {
        return this.hasAccess(user, isPreAuthenticated) && (Boolean.TRUE == isPreAuthenticated || this.passMatches(credentials.getPassword(), user.getPassword()));
    }

    protected boolean passMatches(String passGiven, String passStored) {
        return this.passwordEncoder.matches((CharSequence)passGiven, passStored);
    }

    protected boolean hasAccess(Account user, Boolean isPreAuthenticated) {
        if (!isPreAuthenticated.booleanValue()) {
            user.setCredentialsNonExpired(this.credentialsNonExpired(user));
        }
        return user.isEnabled() && user.isAccountNonExpired() && user.isAccountNonLocked() && user.isCredentialsNonExpired();
    }

    protected boolean credentialsNonExpired(Account user) {
        Long passExpirySeconds = this.passExpirySeconds(user);
        if (passExpirySeconds != null) {
            boolean passExpired;
            boolean bl = passExpired = user.getPassChangeDate() == null || Instant.now().minusSeconds(passExpirySeconds).isAfter(user.getPassChangeDate());
            if (passExpired) {
                log.info("User's password has expired, username: {}", (Object)user.getUsername());
                return false;
            }
        }
        return user.isCredentialsNonExpired();
    }

    protected Long passExpirySeconds(Account user) {
        if (!this.passExpiryEnabled) {
            return null;
        }
        Set roles = Optional.ofNullable(user.getRoleContexts()).map(rc -> rc.stream().flatMap(r -> r.getRoles().stream()).collect(Collectors.toSet())).orElseGet(HashSet::new);
        if (roles.contains(this.passExpiryRole) && !roles.contains(this.passExpiryExceptRole) && !roles.contains("ROLE_ADMIN")) {
            return this.passExpirySeconds > 0L ? Long.valueOf(this.passExpirySeconds) : null;
        }
        return null;
    }

    protected Map<String, Object> buildTokenMap(AccessToken accessToken, AccessToken refreshToken, Account user) {
        HashMap<String, Object> tokenMap = new HashMap<String, Object>();
        tokenMap.put("scope", accessToken.getRoles());
        if (accessToken.getExpiration() != null) {
            tokenMap.put("expires_in", accessToken.getExpiration().getTime() - System.currentTimeMillis());
            tokenMap.put("access_expires", accessToken.getExpiration());
        }
        tokenMap.put("access_token", accessToken.getToken());
        tokenMap.put("details", accessToken.getDetails());
        if (user != null) {
            tokenMap.put("username", user.getUsername());
        }
        tokenMap.put("token_type", "Bearer");
        if (refreshToken != null) {
            tokenMap.put("refresh_token", refreshToken.getToken());
            tokenMap.put("refresh_expires", refreshToken.getExpiration());
        }
        return tokenMap;
    }

    public Mono<Instant> revokeAllTokens(Instant instant) {
        log.debug("revokeAllTokens: instant = {}", (Object)instant);
        return this.tokenFactory.revokeAllBefore(instant).thenReturn((Object)instant);
    }

    public Mono<EditResult> revokeToken(String tokenText) {
        return this.tokenFactory.revokeRefresh(tokenText).map(jws -> new EditResult("revokeToken", JwsAccessToken.class, jws.getId()));
    }

    public Mono<Map<String, Object>> refresh(String tokenText) {
        try {
            Mono tokenMono = this.tokenFactory.validateRefresh(tokenText);
            return tokenMono.flatMap(token -> {
                String username = token.getSubject();
                Credentials credentials = new Credentials(username, null, token.getOrgId());
                log.debug("refreshToken for {}", (Object)credentials);
                return this.loadDao.load((Object)username).map(account -> {
                    Map<String, Object> details = this.buildDetails(credentials, (Account)account);
                    log.debug("refresh: {} details {}", (Object)username, details);
                    List authorities = this.findRoles(credentials, (Account)account).stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
                    JsonWebAuthenticationToken auth = new JsonWebAuthenticationToken(account.getUsername(), null, details, authorities);
                    JwsAccessToken accessToken = (JwsAccessToken)this.tokenFactory.createAccessToken((Object)auth);
                    return this.buildTokenMap((AccessToken)accessToken, null, (Account)account);
                });
            });
        }
        catch (AuthenticationException e) {
            log.info(((Object)((Object)e)).getClass().getSimpleName() + " : " + e);
            return Mono.error((Throwable)e);
        }
    }

    public Mono<Map<String, Object>> decode(String tokenText) {
        return this.tokenFactory.parseTokenAsync(tokenText).map(token -> {
            Map<String, Object> tokenMap = this.buildTokenMap((AccessToken)token, null, null);
            tokenMap.put("subject", token.getSubject());
            tokenMap.put("details", token.getDetails());
            tokenMap.put("id", token.getId());
            tokenMap.remove("access_token");
            return tokenMap;
        });
    }

    public Mono<Map<String, Object>> systemToken(TokenRequest request) {
        Assert.hasText((String)request.getUsername(), (String)"username");
        Assert.notNull((Object)request.getRoles(), (String)"roles");
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("orgId", request.getOrgId());
        AccessToken accessToken = (AccessToken)this.tokenFactory.createSystemToken(request.getUsername(), details, request.getRoles().toArray(new String[0]));
        return Mono.just(this.buildTokenMap(accessToken, null, new Account(request.getUsername())));
    }

    public Mono<Map<String, Object>> switchOrg(String orgId) {
        throw new UnsupportedOperationException("TokenAuthService.switchOrg not supported");
    }
}

