/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.flux.client;

import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import reactor.core.publisher.Mono;

public class ReactivePropagateJwtRequestProcessor {
    public static ExchangeFilterFunction asExchangeFilterFunction() {
        return ExchangeFilterFunction.ofRequestProcessor(ReactivePropagateJwtRequestProcessor::propagateJwt);
    }

    public static Mono<ClientRequest> propagateJwt(ClientRequest request) {
        return ReactiveSecurityContextHolder.getContext().map(securityContext -> {
            if (securityContext.getAuthentication() != null && securityContext.getAuthentication() instanceof AbstractAuthenticationToken) {
                Object token = securityContext.getAuthentication().getCredentials();
                return ClientRequest.from((ClientRequest)request).header("Authorization", new String[]{"Bearer " + token}).build();
            }
            return request;
        });
    }
}

