/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.flux.rest;

import inc.yukawa.chain.base.core.domain.result.EditResult;
import inc.yukawa.chain.base.core.domain.result.QueryResult;
import inc.yukawa.chain.base.webflux.ctrl.RestAspectCtrl;
import inc.yukawa.chain.security.domain.Account;
import inc.yukawa.chain.security.filter.AccountFilter;
import inc.yukawa.chain.security.service.AccountAspect;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Tag(name="Account")
@RestController
@RequestMapping(path={"/accounts"}, produces={"application/json", "text/xml"})
@Profile(value={"accounts-aspect"})
@Component
public class AccountFluxController
extends RestAspectCtrl<AccountAspect> {
    private static final Logger log = LoggerFactory.getLogger(AccountFluxController.class);

    @Autowired
    public AccountFluxController(AccountAspect service) {
        super((Object)service);
    }

    @GetMapping(value={"/"})
    @ResponseBody
    @Operation(summary="findAccounts")
    public Flux<Account> findAccounts() {
        return ((AccountAspect)this.getService()).findAccounts(new AccountFilter());
    }

    @PostMapping(path={"/query"})
    @ResponseBody
    @Operation(summary="queryAccounts")
    public Mono<QueryResult<Account>> queryAccounts(@RequestBody(required=false) @Parameter(name="filter") AccountFilter filter) {
        return ((AccountAspect)this.getService()).queryAccounts(filter);
    }

    @GetMapping(value={"/{username}"})
    @ResponseBody
    @Operation(summary="loadAccount")
    public Mono<Account> loadAccount(@Parameter(required=true, example="user") @PathVariable(value="username") String username) {
        log.debug("Load Account by username: {}", (Object)username);
        return ((AccountAspect)this.getService()).loadAccount(username);
    }

    @PutMapping(value={"/"})
    @Operation(summary="editAccount")
    @ResponseStatus(value=HttpStatus.CREATED)
    public Mono<EditResult> editAccount(@RequestBody @Parameter(name="value") Account account) {
        log.debug("editAccount: {}", (Object)account);
        return ((AccountAspect)this.getService()).editAccount(account);
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="deleteAccount")
    public Mono<EditResult> deleteAccount(@Parameter(required=true, example="user") @PathVariable(value="id") String id) {
        log.debug("Delete Account: {}", (Object)id);
        return ((AccountAspect)this.getService()).deleteAccount(id);
    }
}

