/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.flux.rest;

import inc.yukawa.chain.security.domain.TokenRequest;
import inc.yukawa.chain.security.kafka.dao.AccountLoadDao2;
import inc.yukawa.chain.security.service.AuthAspect;
import inc.yukawa.chain.security.service.RevocationAspect;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.Instant;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@Tag(name="Admin")
@RestController
@RequestMapping(value={"/admin"}, produces={"application/json", "text/xml"})
@Profile(value={"admin-aspect", "all-aspects", "default"})
public class SecurityAdminRest {
    private static final Logger log = LoggerFactory.getLogger(SecurityAdminRest.class);
    @Autowired(required=false)
    private AccountLoadDao2 loadDao;
    @Autowired
    private AuthAspect<Mono<Map<String, Object>>> authAspect;
    @Autowired(required=false)
    private RevocationAspect revocationAspect;

    @PutMapping(value={"revoke"})
    @Operation(summary="revokeAllTokens", description="kill switch - revoke all before")
    public Mono<Instant> revokeAllTokens(@Parameter(name="cutOff", required=true, example="2019-09-05T10:15:30.00Z") @RequestParam(name="cutOff", required=true) Instant instant) {
        return this.revocationAspect.revokeAllBefore(instant).thenReturn((Object)instant);
    }

    @PostMapping(value={"revokeAllUserTokens"})
    @Operation(summary="revokeAllUserTokens", description="kill switch - revoke all user tokens before")
    public Mono<Instant> revokeAllUserTokens(@Parameter(name="username", required=true, example="user@yukawa.de") @RequestParam(name="username") String username, @Parameter(name="cutOff", required=true, example="2019-09-05T10:15:30.00Z") @RequestParam(name="cutOff") Instant instant) {
        return this.revocationAspect.revokeAllBefore(username, instant).thenReturn((Object)instant);
    }

    @PostMapping(value={"revocationsCleanup"})
    @Operation(summary="revocationsCleanup", description="cleans up the outdated revocations only")
    public Mono<Void> revocationsCleanup() {
        return this.revocationAspect.cleanup();
    }

    @PutMapping(value={"decode"}, consumes={"application/json", "text/plain", "text/xml", "application/x-www-form-urlencoded"})
    @Operation(summary="decodeToken")
    public Object decodeToken(@Parameter(required=true) @RequestBody String token) {
        return this.authAspect.decode(token);
    }

    @PostMapping(value={"/systemToken"}, consumes={"application/json", "text/plain", "text/xml", "application/x-www-form-urlencoded"})
    @Operation(summary="systemToken")
    public Mono<ResponseEntity<Map<String, Object>>> systemToken(@Parameter(required=true) @RequestBody TokenRequest request) {
        log.info("Generating system token for: {}", (Object)request);
        return ((Mono)this.authAspect.systemToken(request)).map(ResponseEntity::ok).defaultIfEmpty((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build()).onErrorResume(throwable -> Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build()));
    }
}

