/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.flux.rest;

import inc.yukawa.chain.base.core.domain.result.EditResult;
import inc.yukawa.chain.security.domain.Credentials;
import inc.yukawa.chain.security.flux.rest.BaseFluxController;
import inc.yukawa.chain.security.flux.security.RateLimitService;
import inc.yukawa.chain.security.jwt.token.JwsAccessToken;
import inc.yukawa.chain.security.service.AuthAspect;
import inc.yukawa.chain.security.service.RevocationAspect;
import inc.yukawa.chain.security.service.TokenExtractor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.security.Principal;
import java.time.Instant;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Tag(name="TokenAuth")
@RestController
@RequestMapping(produces={"application/json", "text/xml"})
@Profile(value={"token-auth-aspect", "all-aspects", "default"})
public class TokenAuthFluxController
extends BaseFluxController {
    private static final Logger log = LoggerFactory.getLogger(TokenAuthFluxController.class);
    private final ReactiveUserDetailsService userDetailsService;
    @Autowired
    private TokenExtractor tokenExtractor;
    @Autowired(required=false)
    private RevocationAspect revocationAspect;
    @Autowired(required=false)
    @Qualifier(value="authRateLimitService")
    private RateLimitService rateLimitService;
    private final AuthAspect<Mono<Map<String, Object>>> authService;

    public TokenAuthFluxController(ReactiveUserDetailsService userDetailsService, AuthAspect<Mono<Map<String, Object>>> authService) {
        this.userDetailsService = userDetailsService;
        this.authService = authService;
    }

    @PostMapping(value={"/auth/token"}, consumes={"application/json", "text/xml", "application/x-www-form-urlencoded"})
    @Operation(summary="createToken", description="crate new auth + refresh token")
    public Mono<ResponseEntity<Map<String, Object>>> createToken(@Parameter(required=true) @RequestBody @io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json", examples={@ExampleObject(name="user/pass", value="{\n    \"username\": \"admin\",\n    \"password\": \"pass\"\n}\n"), @ExampleObject(name="GoogleIdToken", value="{\n  \"password\": \"put_google_id_token_here\",\n  \"provider\": \"GOOGLE_ID_TOKEN\"\n}\n"), @ExampleObject(name="AppleIdToken", value="{\n  \"password\": \"put_apple_id_token_here\",\n  \"provider\": \"APPLE_ID_TOKEN\"\n}\n"), @ExampleObject(name="AppleAuthCode", value="{\n  \"password\": \"put_auth_code_here\",\n  \"provider\": \"APPLE_AUTH_CODE\"\n}\n"), @ExampleObject(name="full")})}) Credentials credentials, ServerWebExchange exchange) {
        boolean hasExternalToken;
        String username = credentials.getUsername();
        log.debug("createToken: {} {}", (Object)username, (Object)credentials.getProvider());
        if (username != null && this.rateLimitService != null) {
            this.rateLimitService.consume(username);
        }
        boolean hasUsernameAndPass = StringUtils.hasText((String)username) && StringUtils.hasText((String)credentials.getPassword());
        boolean bl = hasExternalToken = StringUtils.hasText((String)credentials.getPassword()) && StringUtils.hasText((String)credentials.getProvider());
        if (!hasUsernameAndPass && !hasExternalToken) {
            log.debug("no user/pass nor provider/pass provided: {}", (Object)credentials);
            return Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build());
        }
        if (credentials.getOrgId() == null) {
            credentials.setOrgId(this.findOrgId(exchange));
        }
        return ((Mono)this.authService.login(credentials)).map(ResponseEntity::ok).defaultIfEmpty((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build()).doOnError(e -> !(e instanceof AuthenticationException), e -> log.debug("Login error", e)).onErrorResume(e -> e instanceof AuthenticationException, throwable -> Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build()));
    }

    @GetMapping(value={"/auth/refresh"})
    @Operation(summary="refreshToken", description="refresh access token")
    public Mono<ResponseEntity<Map<String, Object>>> refreshToken(@RequestHeader(value="Authorization") @Parameter(example="Bearer eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJ1c2VyIiwiaWF0IjoxNTg1MzgyOTg1LCJqdGkiOiIyZWQ5MjFiZC05ZmEzLTQ2NGYtODhhZi05OTE0MWRhZjE2YjciLCJleHAiOjE1ODYwOTkzODUsInNjb3BlIjpbIlJPTEVfUkVGUkVTSF9UT0tFTiJdLCJkZXRhaWxzIjp7InRlc3RVc2VyIjp0cnVlfX0.xO6NSae_m3iQXg9LPcgKJGmTR4BJLHS_Sk9Z2DPrjog") String authHeader) {
        String tokenText = this.tokenExtractor.extract(authHeader);
        if (!StringUtils.hasText((String)tokenText)) {
            return Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build());
        }
        return ((Mono)this.authService.refresh(tokenText)).map(map -> new ResponseEntity(map, (HttpStatusCode)HttpStatus.OK)).defaultIfEmpty((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build()).onErrorResume(throwable -> Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build()));
    }

    @DeleteMapping(value={"/auth/refresh"})
    @Operation(summary="revokeToken")
    public Mono<EditResult> revokeToken(@RequestHeader(value="Authorization") @Parameter(example="Bearer eyJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJ1c2VyIiwiaWF0IjoxNTg1MzgyOTg1LCJqdGkiOiIyZWQ5MjFiZC05ZmEzLTQ2NGYtODhhZi05OTE0MWRhZjE2YjciLCJleHAiOjE1ODYwOTkzODUsInNjb3BlIjpbIlJPTEVfUkVGUkVTSF9UT0tFTiJdLCJkZXRhaWxzIjp7InRlc3RVc2VyIjp0cnVlfX0.xO6NSae_m3iQXg9LPcgKJGmTR4BJLHS_Sk9Z2DPrjog") String authHeader) {
        String tokenText = this.tokenExtractor.extract(authHeader);
        return this.authService.revokeToken(tokenText);
    }

    @PostMapping(value={"/auth/revokeAll"})
    @Operation(summary="revokeAllMyTokens", description="revokes all calling user refresh tokens")
    public Mono<EditResult> revokeAllTokens() {
        return ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).map(Principal::getName).flatMap(username -> this.revocationAspect.revokeAllBefore(username, Instant.now())).thenReturn((Object)new EditResult("revokeAllMyTokens", JwsAccessToken.class, "OK"));
    }

    @GetMapping(value={"/auth/account"})
    @Operation(summary="loadAccount", description="logged in user details")
    public Mono<UserDetails> loadAccount() {
        return ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).map(Principal::getName).flatMap(arg_0 -> ((ReactiveUserDetailsService)this.userDetailsService).findByUsername(arg_0));
    }

    @PostMapping(value={"/auth/org"})
    @Operation(summary="switchOrg", description="switch organisation / tenant")
    public Mono<ResponseEntity<Map<String, Object>>> switchOrg(@RequestParam String orgId) {
        return ((Mono)this.authService.switchOrg(orgId)).map(ResponseEntity::ok).defaultIfEmpty((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build()).onErrorResume(throwable -> Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build()));
    }
}

