/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.flux.security;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class RateLimitService {
    private static final Logger LOG = LoggerFactory.getLogger(RateLimitService.class);
    private final Map<String, Bucket> buckets = new ConcurrentHashMap<String, Bucket>();
    private final long tokens;
    private final Duration refillDuration;

    public RateLimitService(long tokens, Duration refillDuration) {
        this.tokens = tokens;
        this.refillDuration = refillDuration;
    }

    public void consume(String key) {
        Bucket bucket = this.resolveBucket(key);
        if (!bucket.tryConsume(1L)) {
            LOG.info("Rate limit exceeded for: {}, bucket: ", (Object)key);
            throw WebClientResponseException.create((int)HttpStatus.TOO_MANY_REQUESTS.value(), (String)HttpStatus.TOO_MANY_REQUESTS.getReasonPhrase(), null, null, null);
        }
    }

    public Mono<Void> consume(Mono<String> keyMono) {
        return keyMono.map(key -> {
            this.consume((String)key);
            return key;
        }).then();
    }

    protected Bucket resolveBucket(String key) {
        return this.buckets.computeIfAbsent(key, this::newBucket);
    }

    protected Bucket newBucket(String key) {
        return this.bucket(this.tokens, this.refillDuration);
    }

    protected Bucket bucket(long tokens, Duration refillDuration) {
        Bandwidth limit = Bandwidth.builder().capacity(tokens).refillGreedy(tokens, refillDuration).build();
        return Bucket.builder().addLimit(limit).build();
    }
}

