/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.flux.rest;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.springframework.web.server.ServerWebExchange;

public abstract class BaseFluxController {
    protected String findOrgId(ServerWebExchange exchange) {
        String orgId = exchange.getRequest().getHeaders().getFirst("OrgId");
        if (orgId != null) {
            return orgId;
        }
        String[] refs = this.extractBaseCredentials(exchange);
        orgId = refs[0];
        if (orgId != null && orgId.trim().isEmpty()) {
            orgId = null;
        }
        return orgId;
    }

    protected String[] extractBaseCredentials(ServerWebExchange exchange) {
        List authHeaders = exchange.getRequest().getHeaders().get((Object)"Authorization");
        if (authHeaders != null && !authHeaders.isEmpty()) {
            try {
                String authorization = (String)authHeaders.get(0);
                if (authorization != null && authorization.toLowerCase().startsWith("basic")) {
                    String base64Credentials = authorization.substring("Basic".length()).trim();
                    byte[] credDecoded = Base64.getDecoder().decode(base64Credentials);
                    String credentials = new String(credDecoded, StandardCharsets.UTF_8);
                    return credentials.split(":", 2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new String[2];
    }
}

