/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.flux.rest;

import inc.yukawa.chain.security.domain.Credentials;
import inc.yukawa.chain.security.flux.rest.BaseFluxController;
import inc.yukawa.chain.security.flux.security.RateLimitService;
import inc.yukawa.chain.security.service.AuthAspect;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Tag(name="OAuth")
@RestController
@RequestMapping(produces={"application/json", "text/xml"})
@Profile(value={"oauth-auth-aspect", "all-aspects", "default"})
public class OAuthFluxController
extends BaseFluxController {
    private static final Logger log = LoggerFactory.getLogger(OAuthFluxController.class);
    private final AuthAspect<Mono<Map<String, Object>>> authService;
    @Autowired(required=false)
    @Qualifier(value="authRateLimitService")
    private RateLimitService rateLimitService;

    public OAuthFluxController(AuthAspect<Mono<Map<String, Object>>> authService) {
        this.authService = authService;
    }

    @PostMapping(value={"/oauth/token"}, consumes={"application/x-www-form-urlencoded"})
    @Operation(summary="oAuthToken", description="crate new auth + refresh token")
    public Mono<ResponseEntity<Map<String, Object>>> oAuthToken(ServerWebExchange exchange) {
        return exchange.getFormData().flatMap(form -> {
            String grant_type = (String)form.getFirst((Object)"grant_type");
            String orgId = this.findOrgId(exchange, (MultiValueMap<String, String>)form);
            log.debug("oAuthToken: grant_type = {}, orgId = {}", (Object)grant_type, (Object)orgId);
            if ("password".equals(grant_type)) {
                String username = (String)form.getFirst((Object)"username");
                if (username != null && this.rateLimitService != null) {
                    this.rateLimitService.consume(username);
                }
                return ((Mono)this.authService.login(new Credentials(username, (String)form.getFirst((Object)"password"), orgId))).map(ResponseEntity::ok).onErrorResume(throwable -> Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build())).defaultIfEmpty((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build());
            }
            if ("refresh_token".equals(grant_type)) {
                return ((Mono)this.authService.refresh((String)form.getFirst((Object)"refresh_token"))).map(map -> new ResponseEntity(map, (HttpStatusCode)HttpStatus.OK)).onErrorResume(throwable -> Mono.just((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build())).defaultIfEmpty((Object)ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build());
            }
            return Mono.just((Object)new ResponseEntity(Collections.singletonMap("error", "unsupported_grant_type"), (HttpStatusCode)HttpStatus.BAD_REQUEST));
        });
    }

    protected String findOrgId(ServerWebExchange exchange, MultiValueMap<String, String> form) {
        String clientId = (String)form.getFirst((Object)"client_id");
        if (StringUtils.hasText((String)clientId)) {
            return clientId;
        }
        clientId = (String)form.getFirst((Object)"orgId");
        if (StringUtils.hasText((String)clientId)) {
            return clientId;
        }
        return super.findOrgId(exchange);
    }
}

